package cl.usm.android;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;


import android.text.Editable;
import android.text.TextWatcher;
import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

public class Servidor extends Activity {

	private Button start_server;
	private Button stop_server;
	private TextView total_votos;
	private boolean done;
	private TextView port_monitor;
	private TextView port_televisor;
	
	int progress_0, progress_1, progress_2, progress_3, progress_4,
	progress_5;
	
	private ProgressBar votos_0, votos_1, votos_2, votos_3, votos_4, votos_5;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		total_votos = (TextView) findViewById(R.id.total_votos);
		
		
		votos_0 = (ProgressBar) findViewById(R.id.progressBar1);
		votos_1 = (ProgressBar) findViewById(R.id.progressBar2);
		votos_2 = (ProgressBar) findViewById(R.id.progressBar3);
		votos_3 = (ProgressBar) findViewById(R.id.progressBar4);
		votos_4 = (ProgressBar) findViewById(R.id.progressBar5);
		votos_5 = (ProgressBar) findViewById(R.id.progressBar6);
		port_televisor = (TextView) findViewById(R.id.port_tv_value);
		port_televisor.addTextChangedListener(new AcumulatorServer());
		port_monitor = (TextView) findViewById(R.id.port_monitor_value);
		port_monitor.addTextChangedListener(new MonitorServer());
		
		stop_server = (Button) findViewById(R.id.stop_server);
		stop_server.setOnClickListener(new Button.OnClickListener() {
			public void onClick(View arg0) {
				done = true;
			}
		});
		start_server = (Button) findViewById(R.id.start_server);
		start_server.setOnClickListener(new Button.OnClickListener() {
			public void onClick(View arg0) {
				start_server.setEnabled(false);
				stop_server.setEnabled(true);
				done = false;
				new AcumulatorServer().execute();
				new MonitorServer().execute();
			}
		});

	}

	private class AcumulatorServer extends AsyncTask<Void, Integer, Void> /*implements TextWatcher*/ implements TextWatcher{
		ServerSocket serverSocket = null;
		Socket socket = null;
		DataInputStream dataInputStream = null;
		DataOutputStream dataOutputStream = null;

		String buffer;
		int votos_totales;
		

		protected void onPostExecute(Void result) {
			start_server.setClickable(true);
			start_server.setEnabled(true);

			stop_server.setEnabled(false);

			if (serverSocket != null) {
				try {
					serverSocket.close();
				} catch (IOException e) {
					Log.e("Cliente", "IOException", e);
				}
			}
		}

		protected void onPreExecute() {
			votos_totales = 0;
			progress_0 = 0;
			progress_1 = 0;
			progress_2 = 0;
			progress_3 = 0;
			progress_4 = 0;
			progress_5 = 0;

			votos_0.setMax(votos_totales);
			votos_1.setMax(votos_totales);
			votos_2.setMax(votos_totales);
			votos_3.setMax(votos_totales);
			votos_4.setMax(votos_totales);
			votos_5.setMax(votos_totales);

			votos_0.setProgress(progress_0);
			votos_1.setProgress(progress_1);
			votos_2.setProgress(progress_2);
			votos_3.setProgress(progress_3);
			votos_4.setProgress(progress_4);
			votos_5.setProgress(progress_5);

			try {
				serverSocket = new ServerSocket(Integer.parseInt(port_televisor.getText().toString()));
				Toast.makeText(getApplicationContext(),
						"Acumulador iniciado...", Toast.LENGTH_SHORT);
			} catch (IOException e) {
				Log.e("Servidor", "IOException", e);
			}
		}

		protected void onProgressUpdate(Integer... values) {
			votos_totales++;
			total_votos.setText("Votos totales: " + votos_totales);

			votos_0.setMax(votos_totales);
			votos_1.setMax(votos_totales);
			votos_2.setMax(votos_totales);
			votos_3.setMax(votos_totales);
			votos_4.setMax(votos_totales);
			votos_5.setMax(votos_totales);

			switch (values[0]) {
			case 0:
				progress_0++;
				break;
			case 1:
				progress_1++;
				break;
			case 2:
				progress_2++;
				break;
			case 3:
				progress_3++;
				break;
			case 4:
				progress_4++;
				break;
			case 5:
				progress_5++;
				break;
			}

			votos_0.setProgress(0);
			votos_1.setProgress(0);
			votos_2.setProgress(0);
			votos_3.setProgress(0);
			votos_4.setProgress(0);
			votos_5.setProgress(0);

			votos_0.setProgress(progress_0);
			votos_1.setProgress(progress_1);
			votos_2.setProgress(progress_2);
			votos_3.setProgress(progress_3);
			votos_4.setProgress(progress_4);
			votos_5.setProgress(progress_5);
		}

		@Override
		protected Void doInBackground(Void... params) {
			// TODO Auto-generated method stub
			while (!done) {
				try {
					socket = serverSocket.accept();
					dataInputStream = new DataInputStream(
							socket.getInputStream());
					dataOutputStream = new DataOutputStream(
							socket.getOutputStream());
					buffer = dataInputStream.readLine();
					Log.d("Cliente", "" + buffer);
					publishProgress(Integer.parseInt(buffer));
				} catch (IOException e) {
					Log.e("Cliente", "IOException", e);
				} finally {
					if (socket != null) {
						try {
							socket.close();
						} catch (IOException e) {
							Log.e("Cliente", "IOException", e);
						}
					}

					if (dataInputStream != null) {
						try {
							dataInputStream.close();
						} catch (IOException e) {
							Log.e("Cliente", "IOException", e);
						}
					}

					if (dataOutputStream != null) {
						try {
							dataOutputStream.close();
						} catch (IOException e) {
							Log.e("Cliente", "IOException", e);
						}
					}
				}
			}

			return null;
		}

		@Override
		public void afterTextChanged(Editable s) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void beforeTextChanged(CharSequence s, int start, int count,
				int after) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void onTextChanged(CharSequence s, int start, int before,
				int count) {
			// TODO Auto-generated method stub
			
		}
	}

	
	private class MonitorServer extends AsyncTask<Void, Integer, Void> /*implements TextWatcher*/ implements TextWatcher{
		ServerSocket serverSocket = null;
		Socket socket = null;
		DataInputStream dataInputStream = null;
		DataOutputStream dataOutputStream = null;

		String buffer;
	    

		protected void onPostExecute(Void result) {
			
		}

		protected void onPreExecute() {

			try {
				serverSocket = new ServerSocket(Integer.parseInt(port_monitor.getText().toString()));
				Toast.makeText(getApplicationContext(),
						"Acumulador iniciado...", Toast.LENGTH_SHORT);
			} catch (IOException e) {
				Log.e("Servidor", "IOException", e);
			}
		}

		protected void onProgressUpdate(Integer... values) {
			
		}

		@Override
		protected Void doInBackground(Void... params) {
			// TODO Auto-generated method stub
			while (!done) {
				try {
					socket = serverSocket.accept();
					dataInputStream = new DataInputStream(
							socket.getInputStream());
					dataOutputStream = new DataOutputStream(
							socket.getOutputStream());
					buffer = progress_0 + " " + progress_1 + " " + progress_2 + " " + progress_3 + " " + progress_4 + " " + progress_5;
					
					Log.d("Monitor", "" + buffer);
					dataOutputStream.writeBytes(buffer);
					dataOutputStream.flush();
				} catch (IOException e) {
					Log.e("Cliente", "IOException", e);
				} finally {
					if (socket != null) {
						try {
							socket.close();
						} catch (IOException e) {
							Log.e("Cliente", "IOException", e);
						}
					}

					if (dataInputStream != null) {
						try {
							dataInputStream.close();
						} catch (IOException e) {
							Log.e("Cliente", "IOException", e);
						}
					}

					if (dataOutputStream != null) {
						try {
							dataOutputStream.close();
						} catch (IOException e) {
							Log.e("Cliente", "IOException", e);
						}
					}
				}
			}

			return null;
		}

		@Override
		public void afterTextChanged(Editable s) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void beforeTextChanged(CharSequence s, int start, int count,
				int after) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void onTextChanged(CharSequence s, int start, int before,
				int count) {
			// TODO Auto-generated method stub
			
		}
	}
}